import 'package:admin_desktop/app_constants.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';

class CustomPasswords extends StatelessWidget {
  final VoidCallback onTap;
  final String type;

  const CustomPasswords({super.key, required this.onTap, required this.type});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          child: InkWell(
            onTap: onTap,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                RichText(
                  maxLines: 1,
                  text: TextSpan(
                    text: '${AppHelpers.getTranslation(
                      type == TrKeys.seller
                          ? TrKeys.sellerLogin
                          : TrKeys.masterLogin,
                    )}:',
                    style: Style.interNormal(
                        size: 14, letterSpacing: -0.3, color: Style.black),
                    children: [
                      TextSpan(
                        text:
                            ' ${type == TrKeys.seller ? AppConstants.demoSellerLogin : AppConstants.demoSellerLogin2}',
                        style: Style.interNormal(
                          letterSpacing: -0.3,
                          size: 14,
                          fontStyle: FontStyle.italic,
                        ),
                      )
                    ],
                  ),
                ),
                6.verticalSpace,
                RichText(
                  maxLines: 1,
                  text: TextSpan(
                    text: '${AppHelpers.getTranslation(TrKeys.password)}:',
                    style: Style.interNormal(
                      letterSpacing: -0.3,
                      color: Style.black,
                      size: 14,
                    ),
                    children: [
                      TextSpan(
                        text:
                            ' ${type == TrKeys.seller ? AppConstants.demoSellerPassword : AppConstants.demoSellerPassword2}',
                        style: Style.interNormal(
                          letterSpacing: -0.3,
                          size: 14,
                          fontStyle: FontStyle.italic,
                        ),
                      )
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
        TextButton(
          onPressed: onTap,
          child: Text(
            AppHelpers.getTranslation(TrKeys.copy),
            style: Style.interNormal(size: 14),
          ),
        ),
      ],
    );
  }
}
